'use strict';

chrome.declarativeContent.onPageChanged.removeRules(undefined, function() {
    chrome.declarativeContent.onPageChanged.addRules([{
      conditions: [new chrome.declarativeContent.PageStateMatcher({
        pageUrl: {schemes: ['http','https','www']},
      })
      ],
          actions: [new chrome.declarativeContent.ShowPageAction()]
    }]);
});

chrome.extension.onMessage.addListener(function(request,sender,sendResponse){ 

  chrome.storage.local.get(['idArray', 'index'], function (items) {
    let idArray = items.idArray.split(',');
    let length = idArray.length;
    let index = items.index;

    if(request.nothing == "true"){
      chrome.storage.local.set({index: (index+1)});
      index += 1;
      console.log("Message : nothing ");

    }else if(request.noImage == "true") {
      chrome.storage.local.set({index: (index+2)});
      index += 2;
      console.log("Message : noImages"); 
    }

    if(index >= length) {
      console.log("Last file was downloaded");
      chrome.storage.local.remove(['idArray', 'index']);
    }
  });

});

chrome.downloads.onDeterminingFilename.addListener(function(item, suggest) {

  if(item.url.includes("https://digitallibrary-external.fastretailing.com/api/asset/download/")){
    chrome.storage.local.get(['idArray', 'index'], function (items) {
      if(Object.keys(items).length !== 0){
        let index = items.index;
        let idArray = items.idArray.split(',');
        let new_filename = idArray[index] + ".zip"; 
        
        suggest({filename: new_filename});
  
        if(index + 1 >= idArray.length) {
          console.log("Last file was downloaded");
          chrome.storage.local.remove(['idArray', 'index']);
        }else{
          chrome.storage.local.set({index: (index+1)});
        }
      }else{
        suggest();
      }
      return true;
    });
  }else{
    suggest();
  }

  return true;
});
