'use strict';
var initial = 0;
var skus = [];

chrome.declarativeContent.onPageChanged.removeRules(undefined, function() {
    chrome.declarativeContent.onPageChanged.addRules([{
      conditions: [new chrome.declarativeContent.PageStateMatcher({
        pageUrl: {schemes: ['http','https','www']},
      })
      ],
          actions: [new chrome.declarativeContent.ShowPageAction()]
    }]);
});

chrome.extension.onMessage.addListener(function(request,sender,sendResponse){
  if(request.idArray) {
    skus = request.idArray.split(',');
    console.log(skus);
  } else if(request.nothing == "true") {
    console.log("Message : nothing ");
    initial++;
  } else if(request.noImage == "true") {
    console.log("Message : noImages"); 
    initial += 2;
  }
  console.log("Current index : ", initial);
});

chrome.downloads.onDeterminingFilename.addListener(function(item, suggest) {
  var new_filename = skus[initial] + ".zip"; 
  suggest({filename: new_filename});
  initial++;
});
